<?php
require 'koneksi.php';
require_once("dompdf/autoload.inc.php");

use Dompdf\Dompdf;
use Dompdf\Options;

// **Dompdf Configuration**
$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('isHtml5ParserEnabled', true);
$options->set('defaultFont', 'Arial');
$options->set('isPhpEnabled', true);
$options->set('isFontSubsettingEnabled', true);

$dompdf = new Dompdf($options);

// **Retrieve Data from Database**
$bobot = query("SELECT * FROM bobot2")[0];
$nilai_alternatif = query("SELECT * FROM channel ORDER BY id");  // Sorted by channel name
$hasil_vektor_s = query("SELECT * FROM vektors2 ORDER BY id");  // Sorted by channel name
$hasil_vektor_v = query("SELECT * FROM hasil2 ORDER BY id_hasil");  // Sorted by channel name
$ranking = query("SELECT * FROM hasil2 ORDER BY nilai DESC");

// **Check if data is available**
if (empty($bobot) || empty($nilai_alternatif) || empty($hasil_vektor_s) || empty($hasil_vektor_v)) {
    die("Data not available! Make sure the tables `bobot2`, `input_nilai2`, `vektors2`, and `hasil2` are filled.");
}

// **Calculate total weight**
$jumlah_bobot = array_sum($bobot);
if ($jumlah_bobot == 0) {
    die("Weight must not be zero! Please check the input weights.");
}

// **Normalize Weights**
$w = [];
foreach ($bobot as $key => $value) {
    if ($key != 'id_bobot2') {
        $w[$key] = $value / $jumlah_bobot;
    }
}

// **Total Vector S & V**
$total_s = array_sum(array_column($hasil_vektor_s, 'nilai'));
$total_v = array_sum(array_column($hasil_vektor_v, 'nilai'));

// **Auto Date**
$tanggal = date("d-m-Y");

// **HTML Structure for PDF**
$html = '<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        .table1 {
            width: 100%;
            border-collapse: collapse;
            text-align: center;
        }
        .table1, th, td {
            border: 1px solid #000;
            padding: 5px;
            font-size: 10px;
        }
        h2, p {
            text-align: center;
        }
        h3 {
            text-decoration: underline;
            text-align: center;
        }
        h1 {
            text-align: center;
            font-size: 22px;
        }
    </style>
</head>
<body>

    <br>
    <h1>Report of YouTube Channel Recommendation Results as Learning Media for Informatics Engineering Students Using the Weighted Product Method</h1>
    <br>
    <h2>Nusa Putra University</h2>
    <p>Sukabumi - Bogor - West Java - Indonesia</p>
    <p>Date: ' . htmlspecialchars($tanggal) . '</p>
<hr style="border: 2px solid black;" />

    <br><br>';

// **Criteria Weight Table**
$html .= '<h3>Criteria Weight Data</h3>
<table class="table1">
<tr>
    <th>Criteria</th>
    <th>Weight</th>
    <th>Normalized Weight</th>
</tr>';

foreach ($w as $key => $value) {
    $html .= '<tr>
        <td>' . strtoupper($key) . '</td>
        <td>' . intval($bobot[$key]) . '</td>  <!-- No decimal -->
        <td>' . number_format($value, 6) . '</td>  <!-- Show 6 decimal places -->
    </tr>';
}
$html .= '</table><br><br>';
$html .= '<hr style="border: 1px solid #ccc;">';

// **Alternative Value Table**
$html .= '<h3>Alternative Value Data</h3>
<table class="table1">
<tr>
    <th>No.</th>
    <th>Channel Name</th>
    <th>C1</th>
    <th>C2</th>
    <th>C3</th>
    <th>C4</th>
    <th>C5</th>
</tr>';

$no = 1;
foreach ($nilai_alternatif as $alt) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($alt["nama"]) . '</td>
        <td>' . intval($alt["c1"]) . '</td>  <!-- No decimal -->
        <td>' . intval($alt["c2"]) . '</td>
        <td>' . intval($alt["c3"]) . '</td>
        <td>' . intval($alt["c4"]) . '</td>
        <td>' . intval($alt["c5"]) . '</td>
    </tr>';
}
$html .= '</table><br><br>';
$html .= '<hr style="border: 1px solid #ccc;">';

// **Vector S Result Table**
$html .= '<h3>Vector S Results</h3>
<table class="table1">
<tr>
    <th>No.</th>
    <th>Alternative</th>
    <th>Vector S Value</th>
</tr>';

$no = 1;
foreach ($hasil_vektor_s as $data) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($data["nama"]) . '</td>
        <td>' . number_format($data["nilai"], 6) . '</td>  <!-- Show 6 decimal places -->
    </tr>';
}
$html .= '</table><br><br>';
$html .= "<p style='text-align:center; font-weight:bold;'>Total Vector S Value: " . number_format($total_s, 6) . "</p><br><br>";
$html .= '</table><br><br>';
$html .= '<hr style="border: 1px solid #ccc;">';

// **Vector V Result Table**
$html .= '<h3>Vector V Results</h3>
<table class="table1">
<tr>
    <th>No.</th>
    <th>Alternative</th>
    <th>Vector V Value</th>
</tr>';

$no = 1;
foreach ($hasil_vektor_v as $data) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($data["nama"]) . '</td>
        <td>' . number_format($data["nilai"], 6) . '</td>  <!-- Show 6 decimal places -->
    </tr>';
}
$html .= '</table><br><br>';
$html .= "<p style='text-align:center; font-weight:bold;'>Total Vector V Value: " . number_format($total_v, 6) . "</p><br><br>";
$html .= '</table><br><br>';
$html .= '<hr style="border: 1px solid #ccc;">';

// **Ranking Result Table**
$html .= '<h3>Ranking Results</h3>
<table class="table1">
<tr>
    <th>Rank</th>
    <th>Channel Name</th>
    <th>Value</th>
</tr>';

$no = 1;
foreach ($ranking as $data) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($data["nama"]) . '</td>
        <td>' . number_format($data["nilai"], 6) . '</td>  <!-- Show 6 decimal places -->
    </tr>';
}
$html .= '</table><br><br>';

// **Close HTML**
$html .= "</body></html>";

// **Generate PDF with Dompdf**
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'landscape');
$dompdf->render();
$dompdf->stream('YouTube_Channel_Evaluation_Report.pdf', array("Attachment" => 0));
?>
